//DTMF Signal Detection
//OS:Windows 10
//Scilab 5.5.2

clear all;
clc;
close;

row_f1=[800 870 950 990];     // Row Frequency
colum_f1=[1340 1440 1540];    // Column Frequency
fs=8000;                      // Sampling Frequency
N=1:800;                      // Total No. of Samples for each Digit
mobile=[5 6 7 8 9 0 1 2 3 4];
total_signal=[];

figure;

for i=1:length(mobile)
    select mobile(i)
    case 1
        row_f=1;
        colum_f=1;
    case 2
        row_f=1;
        colum_f=2;
    case 3
        row_f=1;
        colum_f=3;
    case 4
        row_f=2;
        colum_f=1;
    case 5
        row_f=2;
        colum_f=2;
    case 6
        row_f=2;
        colum_f=3;
     case 7
        row_f=3;
        colum_f=1;
    case 8
        row_f=3;
        colum_f=2;
    case 9
        row_f=3;
        colum_f=3;
     case 0
        row_f=4;
        colum_f=2;
    else
        row_f=4;
        colum_f=1;
    end    
     y=sin(2*3.14*(row_f1(row_f)/fs)*N)+sin(2*3.14*(colum_f1(colum_f)/fs)*N);  //Time Domain Signal Generation for each Digit     
     total_signal=[total_signal y zeros(1,8800)];
     temp(:,:,i)=y(:,:);   
    end
    plot(total_signal);
    title('DTMF Signal','color','blue');
    xlabel("Samples","color", "blue");
    ylabel("Amplitude","color", "blue");
    sound(total_signal,fs);
    
row_f=[];
col_f=[];

for i=1:10
    n=length(temp(:,:,i));
    p=abs(fft(temp(:,:,i))); // FFT of Signal of respective Digit
    f=(0:n-1)*fs/n;          // Total Frequency Range
    //plot(f,p);
    row=p(2:100);            // Row Frequency separation
    col=p(101:200);          // Column Frequency separation
    [r1 c1]=find(row==max(row));   // Finding the location of peak for Row Frequency
    [r2 c2]=find(col==max(col));   // Finding the location of peak for Column Frequency
    row_f=[row_f 10*c1];            // Array containing peak of Row Freqiency
    col_f=[col_f (10*(c2+100))-10]; // Array containing peak of Column Freqiency 
end

mobile_find=[];  // Blank Array to Store Mobile Number
for i=1:10     // Loop forFinding the Number form the Row and Column Frequency
    if(row_f(i)==800 & col_f(i)==1340)
        n0=1;
        elseif(row_f(i)==800 & col_f(i)==1440)
    n0=2;
    elseif(row_f(i)==800 & col_f(i)==1540)
    n0=3;
    elseif(row_f(i)==870 & col_f(i)==1340)
    n0=4;
    elseif(row_f(i)==870 & col_f(i)==1440)
    n0=5;
    elseif(row_f(i)==870 & col_f(i)==1540)
    n0=6;
    elseif(row_f(i)==950 & col_f(i)==1340)
    n0=7;
    elseif(row_f(i)==950 & col_f(i)==1440)
    n0=8;
    elseif(row_f(i)==950 & col_f(i)==1540)
    n0=9;
    elseif(row_f(i)==990 & col_f(i)==1440)
    n0=0;
end
mobile_find=[mobile_find n0];  // Array containing Decoded Digit of Mobile Number.
end

disp(mobile_find,"Decoded Mobile Number :");
